/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class RC4SecretKey
extends SecretKey {
    protected ByteArrayAttribute value_;
    protected LongAttribute valueLen_;

    public RC4SecretKey() {
        this.keyType_.setLongValue(Key.KeyType.RC4);
    }

    protected RC4SecretKey(Session session, long l) throws TokenException {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.RC4);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        this.valueLen_ = new LongAttribute(Attribute.VALUE_LEN);
        RC4SecretKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        RC4SecretKey rC4SecretKey = (RC4SecretKey)super.clone();
        rC4SecretKey.value_ = (ByteArrayAttribute)this.value_.clone();
        rC4SecretKey.valueLen_ = (LongAttribute)this.valueLen_.clone();
        RC4SecretKey.putAttributesInTable(rC4SecretKey);
        return rC4SecretKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof RC4SecretKey) {
            RC4SecretKey rC4SecretKey = (RC4SecretKey)object;
            bl = this == rC4SecretKey || super.equals(rC4SecretKey) && this.value_.equals(rC4SecretKey.value_) && this.valueLen_.equals(rC4SecretKey.valueLen_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        return new RC4SecretKey(session, l);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    public LongAttribute getValueLen() {
        return this.valueLen_;
    }

    protected static void putAttributesInTable(RC4SecretKey rC4SecretKey) {
        if (rC4SecretKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        rC4SecretKey.attributeTable_.put(Attribute.VALUE, rC4SecretKey.value_);
        rC4SecretKey.attributeTable_.put(Attribute.VALUE_LEN, rC4SecretKey.valueLen_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
        Object.getAttributeValue(session, this.objectHandle_, this.valueLen_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value Length (dec): ");
        stringBuffer.append(this.valueLen_.toString(10));
        return stringBuffer.toString();
    }
}

